`timescale 1ps / 1ps

module tb;

    // Testbench signals
    reg  [3:0] a_tb = 4'b0000;
    reg  [3:0] b_tb = 4'b0000;
    reg        cin_tb = 1'b0;
    wire [2:0]cout_tb;
    wire [4:0] s_tb;

    // Instantiate the Unit Under Test (UUT)
    labadder uut (
        .a(a_tb),
        .b(b_tb),
        .cin(cin_tb),
        .cout(cout_tb),
        .s(s_tb)
    );
    
    // Stimulus
    initial begin
	$sdf_annotate("labadder_m.sdf",uut,,"sdf.log","MAXIMUM");
        a_tb = 4'b0000;
        b_tb = 4'b0000;
        cin_tb = 1'b0;
        #300;

        a_tb = 4'b0101;
        b_tb = 4'b0011;
        cin_tb = 1'b0;
        #300;

        a_tb = 4'b1001;
        b_tb = 4'b0110;
        cin_tb = 1'b1;
        #300;

        a_tb = 4'b1111;
        b_tb = 4'b1111;
        cin_tb = 1'b1;
        #300;

        a_tb = 4'b0111;
        b_tb = 4'b1000;
        cin_tb = 1'b0;
        #300;

        $stop;
    end

endmodule
