import java.io.*;

public class UserDefinedExceptionExample {

    public static void main(String[] args){

        boolean finished = false;
        do {
            try{
                processUserInput();
            } catch (VowelException x) {
                System.out.println("This is a vowel!");
            } catch (BlankException x) {
                System.out.println("You entered the blank character!");
            } catch (ExitException x) {
                System.out.println("You asked to exit...");
                finished = true;
                System.out.println("End of execution.");
                System.exit(0);   // finally clause not executed
            } finally {
                System.out.println("-----------");
            }

        } while (!finished);
    }

    static void processUserInput() throws VowelException,   BlankException,    ExitException 
    {

        System.out.print("Enter a character (x to exit): ");
        //System.out.flush();
        char ch;

        try {
            BufferedReader kbd = new BufferedReader(new InputStreamReader(System.in));
            String line = kbd.readLine();
            if(line.length() == 0)
                ch = ' ';
            else
                ch = Character.toUpperCase(line.charAt(0));
        } catch (IOException x) {
            System.out.println("An IOException occurred.");
            return;
        }

        switch(ch) {
            case 'A':
            case 'E':
            case 'I':
            case 'O':
            case 'U':
           throw new VowelException();
            case ' ':
            throw new BlankException();
            case 'X':
            throw new ExitException();
        }                                            
    }
}

