//import java.util.Comparable;

public class Department implements Comparable 
{
    private int id;
    private String name;
    private int numberOfStudents;

    public Department(int id, String name, int numberOfStudents){
        this.id = id;
        this.name = name;
        this.numberOfStudents = numberOfStudents;
    }

    // Getters and setters
    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNumberOfStudents() {
        return numberOfStudents;
    }

    public void setNumberOfStudents(int numberOfStudents) {
        this.numberOfStudents = numberOfStudents;
    }

    public void printInfo() {
        System.out.println("Department [id=" + id +  ", name=" + name + ", numberOfStudents=" + numberOfStudents + "]");
    }


    @Override
    public String toString() {
        return "Department [id=" + id + 
               ", name=" + name + 
               ", numberOfStudents=" + numberOfStudents + "]";
    }
    
    public boolean equals(Object o) {
        Department d=(Department)o; // πιθανό να παράγει ClassCastException           
        if (this.id==d.getId() && this.name.equals(d.getName()) && this.numberOfStudents == d.getNumberOfStudents()) {
            return true;
        }
        else {
            return false;
        }
    }
    
    
    public int compareTo(Object o){
        Department d=(Department)o; // πιθανό να παράγει ClassCastException 
        if (this.numberOfStudents>d.getNumberOfStudents()) {
            return 1;
        } 
        else if (this.numberOfStudents<d.getNumberOfStudents()) {
            return -1;
        }
        else {
            return 0;
        }
    }


}