class Student
{
    String studMethod(int id) {
        System.out.println ("\nThe studMethod of class Student has been called.");
        String sid = "general_student_" + id;  
        return sid;
    }
    
    final void printUniv(){
        System.out.println("\nUniversity of Patras");
    }
}

/* UnderGraduateStudent is subclass of Student */
class UnderGraduateStudent extends Student {

    String studMethod(int id) {
        super.studMethod(id);
        System.out.println(" This is an under graduate student.");
        String sid = "bachelor_" + id;
        return sid;
    }
    
    //public void printUniv(){
    //   System.out.println("University of Patras");
    //}
    // τι θα συμβεί αν βγεί το σχόλιο; compilation error, η printUniv είναιfinal
	
}

/* MasterStudent is subclass of Student */
class MasterStudent extends Student
{
    String studMethod(int id) {
        super.studMethod(id);
        System.out.println(" This is a master student.");
        String sid = "master_" + id;
        return sid;
    }
}

public class OverridingExample
{
    public static void main(String[] args) {
        String studID;

        Student stud = new Student();
        //stud.printUniv();
        studID = stud.studMethod(1);
        System.out.println("Student ID: " + studID);
        
        UnderGraduateStudent stud1 = new UnderGraduateStudent(); 
        //stud1.printUniv();
        studID = stud1.studMethod(9999);
        System.out.println("Student ID: " + studID);
                
        MasterStudent stud2 = new MasterStudent(); 
        //stud2.printUniv();
        studID = stud2.studMethod(100);
        System.out.println("Student ID: " + studID);
    }
}



