// Base abstract class
abstract class Shape {
    private String name;
    private String color;

    public Shape(String name, String color) {
        this.name = name;
        this.color = color;
    }

    public abstract double area();

    // Common display method showing name and color
    public void displayInfo() {
        System.out.println("Shape: " + name + " (Color: " + color + ")");
    }

    public String getName() {
        return name;
    }

    public String getColor() {
        return color;
    }
}

// Derived class Circle
class Circle extends Shape {
    private double radius;

    public Circle(String name, String color, double radius) {
        super(name, color);
        this.radius = radius;
    }

    @Override
    public double area() {
        return Math.PI * radius * radius;
    }

    public double getCircumference() {
        return 2 * Math.PI * radius;
    }
}

// Derived class Rectangle
class Rectangle extends Shape {
    private double length;
    private double width;

    public Rectangle(String name, String color, double length, double width) {
        super(name, color);
        this.length = length;
        this.width = width;
    }

    @Override
    public double area() {
        return length * width;
    }

    public double getPerimeter() {
        return 2 * (length + width);
    }
}

// Derived class Triangle
class Triangle extends Shape {
    private double base;
    private double height;

    public Triangle(String name, String color, double base, double height) {
        super(name, color);
        this.base = base;
        this.height = height;
    }

    @Override
    public double area() {
        return 0.5 * base * height;
    }
}

// Main class
public class GeometryDemo {
    public static void main(String[] args) {
        Shape[] shapes = {
            new Circle("Sun Disk", "Golden", 5.0),
            new Rectangle("Book Cover", "Royal Blue", 4.0, 6.0),
            new Triangle("Pyramid", "Sandy", 3.0, 4.0)
        };

        for (Shape shape : shapes) {
            shape.displayInfo();
            System.out.println("Area: " + shape.area());
            
            // Check specific shape types
            if (shape instanceof Circle) {
                Circle circle = (Circle) shape;
                System.out.println("Circumference: " + circle.getCircumference());
            } else if (shape instanceof Rectangle) {
                Rectangle rectangle = (Rectangle) shape;
                System.out.println("Perimeter: " + rectangle.getPerimeter());
            }
            
            System.out.println();
        }
    }
}