import java.util.ArrayList;

class Product {
    int id;
    String name;
    float price;

    public void printProduct() {
        System.out.printf("pr-%d: name=%s, price=%.2f\n", id, name, price);
    }
    
    public Product (int id, String name, float price) {
        this.id = id;
        this.name = name;
        this.price = price;
    }
}


class Order {
    int id;
    ArrayList<Product> products;  // array of structures, assumption on size
    int num_products;       // counter of products
    float total_price;

    public Order (int id) {
        this.id = id;
        this.num_products = 0;
        this.total_price = 0;
        products = new ArrayList<Product>();
    }

    void printOrder() {
        System.out.printf("order-%d: total_price=%.2f\n", this.id, this.total_price);
        for (int i = 0; i < products.size(); i++) {   // products.length ?
            Product pr = products.get(i);
            System.out.printf("%d:", i); 
            pr.printProduct();
        }
    }
    
    public void addProduct(Product pr) {
        int i = this.num_products++; // first store and then increase the value
        products.add(pr);
        this.total_price += pr.price;
    }
    
    /* "method" to access (get) the total price of an order */
    public float getPrice() {
        return total_price;
    }

}

public class Supermarket
{
    public static void main(String args[]) {
        Product a = new Product(1001, "Milko", (float)2.5);
        Product b = new Product(2002, "Rice", (float)6.0);
        Order o = new Order(99);
        
        a.printProduct();
        b.printProduct();
        
        o.addProduct(a);
        o.addProduct(b);
        
        o.printOrder();
        
        System.out.printf("total cost = %.2f\n", o.getPrice());
    }
}
