public class IntegerList {
    private int value;
    private IntegerList next;

    public IntegerList(int n, IntegerList link) {
        value = n;
        next = link;
    }

    public int getValue() {
        return value;
    }

    public IntegerList getNext() {
        return next;
    }

    // New method to append values to the end of the list
    public void add(int value) {
        IntegerList current = this;
        // Traverse to the last node
        while (current.next != null) {
            current = current.next;
        }
        // Append new node at the end
        current.next = new IntegerList(value, null);
    }

    public static void main(String[] args) {
        // Create list with initial value
        IntegerList numbers = new IntegerList(10, null);
        
        // Add values using the new method
        numbers.add(20);
        numbers.add(30);
        numbers.add(40);

        // Traverse and print all values
        IntegerList current = numbers;
        while (current != null) {
            System.out.println(current.getValue());
            current = current.getNext();
        }
    }

}