public class MonteCarloPi {
    public static void main(String[] args) {
        long totalPoints = 10_000_000; // Default number of points
        
        long t0 = System.currentTimeMillis();
        long insideCircle = 0;
        for (long i = 0; i < totalPoints; i++) {
            double x = Math.random();
            double y = Math.random();
            if (x * x + y * y <= 1.0) {
                insideCircle++;
            }
        }
        long t1 = System.currentTimeMillis();
        
        double piEstimate = 4.0 * insideCircle / totalPoints;
        System.out.printf("Estimated Pi: %.10f%n", piEstimate);
        System.out.println("Elapsed time: " + (t1-t0) + " ms");
    }
}