#include <stdio.h>
#include <stdlib.h>
#include <omp.h>
#include <unistd.h>

typedef struct node {
	int val;
	struct node * next;
} node_t;


void push(node_t ** head, int val) {
	node_t * current = *head;
    if (current == NULL) {
		current = (node_t *) malloc(sizeof(node_t));
		current->val = val;
		current->next = NULL;
		*head = current;
		return;
	}

	/* find the end of the list */
	while (current->next != NULL) {
		current = current->next;
	}

	/* now we can add a new node */
	current->next = (node_t *) malloc(sizeof(node_t));
	current->next->val = val;
	current->next->next = NULL;
}

void print_list(node_t * head) {
	node_t * current = head;

	while (current != NULL) {
		printf("%d\n", current->val);
		current = current->next;
	}
}


int process_node(node_t *node)
{
	int val = node->val;
	/* assume that some work must be done here */
	sleep(1);
	return val;
}

int sum_list(node_t * head) {
	node_t * current = head;
	int sum = 0;

	while (current != NULL) {
		sum += process_node(current);
		current = current->next;
	}
	return sum;
}

int sum_list_par(node_t * head) {
	node_t * current = head;
	int sum = 0;

	#pragma omp parallel num_threads(2)
	{
	#pragma omp single nowait
	{
		while (current != NULL) {
			#pragma omp task shared(sum) firstprivate(current)
			{
				int v = process_node(current);

				#pragma omp critical
				{
				sum += v;
				}
			}
			current = current->next;
		}
	}
	}
	return sum;
}

int main(int argc, char *argv[])
{
	double t0, t1;
	int s;
	node_t * head = NULL;

	for (int i=0; i<10; i++) {
		push(&head, i);
	}

	print_list(head);

	t0 = omp_get_wtime();
	s = sum_list(head);
	t1 = omp_get_wtime();
	printf("sum_list_seq returned %d in %.2f s\n", s, t1-t0);

	t0 = omp_get_wtime();
	s = sum_list_par(head);
	t1 = omp_get_wtime();
	printf("sum_list_par returned %d in %.2f s\n", s, t1-t0);

	return 0;
}
