#include <stdio.h>

int fibonacci(int n)
{
	int i, j;

	if (n<2)
		return n;
	else {

		#pragma omp task shared(i) firstprivate(n)
		{
		i = fibonacci(n-1);
		}

		#pragma omp task shared(j) firstprivate(n)
		{
		j = fibonacci(n-2);
		}

		#pragma omp taskwait

		return i + j;
	}
}


int main()
{
	int n;

    printf("Give n="); fflush(0);
	scanf("%d", &n);

#pragma omp parallel shared(n)
{
    #pragma omp single
	{
		int res = fibonacci(n);
		printf("res=%d\n", res);
	}
}

	return 0;
}

