// nested parallel loop with manual fusion
#include <stdio.h>
#include <omp.h>

void work(int i, int j)
{
	printf("work %2d %2d on thread %d\n", i, j, omp_get_thread_num());
}

void nesting(int n)
{
	#pragma omp parallel for
	for (int k=0; k<n*n; k++) {
		int i = k / n;
		int j = k % n;
		work(i, j);
	}
}


int main()
{
        nesting(4);

        return 0;
}

