// nested parallel loop execution by a single parallel region due to the collapse clause
#include <stdio.h>
#include <omp.h>

void work(int i, int j)
{
	printf("work %2d %2d on thread %d\n", i, j, omp_get_thread_num());
}

void nesting(int n)
{
	#pragma omp parallel for collapse(2)
	for (int i=0; i<n; i++) {
	for (int j=0; j<n; j++) {
		work(i, j);
	}
	}
}


int main()
{
        nesting(4);

        return 0;
}

