// demostrates nested parallelism
// $ export OMP_NESTED=false; ./nested_numthreads | sort
// $ export OMP_NESTED=true; ./nested_numthreads | sort
// $ export OMP_NESTED=true; export OMP_THREAD_LIMIT=6; ./nested_numthreads | sort

#include <stdio.h>
#include <omp.h>

void report_num_threads(int level)
{
	#pragma omp single
	{
		printf("Level %d: number of threads in the team = %d\n",
			level, omp_get_num_threads());
	}
}

int main()
{
	omp_set_dynamic(0);
	#pragma omp parallel num_threads(2)
	{
		report_num_threads(1);
		#pragma omp parallel num_threads(2)
		{
			report_num_threads(2);
			#pragma omp parallel num_threads(2)
			{
				report_num_threads(3);
			}
		}
	}

	return(0);
}
