// demostrates nested parallelism 
// export OMP_NESTED=TRUE && ./nested
// export OMP_NESTED=FALSE && ./nested
#include <stdio.h>
#include <omp.h>

int main()
{
	omp_set_num_threads(3);
	omp_set_nested(1);
	#pragma omp parallel
	{
		int tid1 = omp_get_thread_num();
		#pragma omp parallel
		{
			int tid2 = omp_get_thread_num();
			#pragma omp critical
			printf("tid1 = %d, tid2 = %d\n", tid1, tid2);
		}
	}
	return 0;
}