// pi computation using reduction
#include <stdio.h>
#include <omp.h>
#define NUM_THREADS 2
long num_steps = 10000000000;
double step;

int main()
{
	double x, pi, sum = 0.0;
	step = 1.0/(double) num_steps;
	omp_set_num_threads(NUM_THREADS);

	double t0 = omp_get_wtime();
	#pragma omp parallel for reduction(+:sum) private(x)
	for (long i=0; i<num_steps; i++)
	{
		x = (i+0.5)*step;
		sum = sum + 4.0/(1.0+x*x);
	}
	pi = step * sum;
	double t1 = omp_get_wtime();

	printf("Pi is %lf, elapsed time = %f s\n", pi, t1-t0);

	return 0;
}

