// At the core, OpenMP threads are nothing more than POSIX threads
#include <stdio.h>
#include <omp.h>
#include <pthread.h>

#define OMP_ID omp_get_thread_num()
#define PTHREAD_ID pthread_self()

int main()
{
	printf("main(),     thread=%d, pthread_t=%lx\n", OMP_ID, PTHREAD_ID);
	printf("--------\n");

	#pragma omp parallel
	{
		printf("1st region, thread=%d, pthread_t=%lx\n", OMP_ID, PTHREAD_ID);
	}

	printf("--------\n");

	#pragma omp parallel
	{
		printf("2nd region: thread=%d, pthread_t=%lx\n", OMP_ID, PTHREAD_ID);
	}

	return 0;
}
