// pi computation using reduction
#include <stdio.h>
#include <stdlib.h>
#include <omp.h>

#define N 1024
int main()
{
  double *x = malloc(N*sizeof(double));

	for (int i = 0; i < N; i++) x[i] = i+1;

	double sum = -100000;

	#pragma omp parallel reduction(+:sum)
  {

		#pragma omp for //reduction(+:sum) //nowait
    for (int i=0; i<N; i++)
		{
		  //if (i%64 == 0)
			//{
			//	printf("%d [%d] -> sum=%lf\n", omp_get_thread_num(), i, sum);
      //}
			sum += x[i];
		}


		printf("%d -> sum=%lf\n", omp_get_thread_num(), sum);
	}

	printf("sum is %lf\n", sum);

	return 0;
}

