// Thread affinity on MacOS
// export OMP_PROC_BIND=FALSE && ./proc_bind_macos
// export OMP_PROC_BIND=TRUE  && ./proc_bind_macos
// Thread affinity is not supported by MacOS
// See: /usr/include/mach/thread_policy.h

#include <stdio.h>
#include <cpuid.h>
#include <omp.h>

int getcpu()
{
	int CPU;

	u_int32_t CPUInfo[4];
	__cpuid_count(1, 0, CPUInfo[0], CPUInfo[1], CPUInfo[2], CPUInfo[3]);
	/* CPUInfo[1] is EBX, bits 24-31 are APIC ID */
	if ( (CPUInfo[3] & (1 << 9)) == 0) {
		CPU = -1;  /* no APIC on chip */
	}
	else {
		CPU = (unsigned)CPUInfo[1] >> 24;
	}
	if (CPU < 0) CPU = 0;

	return CPU;
}

void test_proc_bind()
{
	#pragma omp parallel
	{
	int tid = omp_get_thread_num();
	int core = getcpu();

	#pragma omp critical
	printf("Thread %d running on core %d\n", tid, core);

	}
}


int main(int argc, char *argv[])
{
	test_proc_bind();

	return 0;
}
