// Thread affinity on Linux
// export OMP_PROC_BIND=FALSE && ./proc_bind_linux
// export OMP_PROC_BIND=TRUE  && ./proc_bind_linux
#define _GNU_SOURCE
#include <stdio.h>
#include <sched.h>
#include <omp.h>

void test_proc_bind()
{
	#pragma omp parallel
	{
	int tid = omp_get_thread_num();
	int core = sched_getcpu();

	#pragma omp critical
	printf("Thread %d running on core %d\n", tid, core);

	}
}


int main(int argc, char *argv[])
{
	test_proc_bind();

	return 0;
}
