// pi computation using reduction
#include <stdio.h>
#include <stdlib.h>
#include <omp.h>

#define N 1024
int main()
{
  int nthreads;

  #pragma omp parallel
  #pragma omp single
  nthreads = omp_get_num_threads();


//  double *x = malloc(nthreads*sizeof(double));
  double x[nthreads];
  for (int i = 0; i < nthreads; i++) x[i] = 10+i;

	#pragma omp parallel firstprivate(x)
  {
		int id = omp_get_thread_num();
		printf("%d -> x[%d]=%f\n", id, id, x[id]);
		x[id] += 100;
	}


  printf("main:after parallel region\n");
  for (int i = 0; i < nthreads; i++)
		printf("x[%d] = %f\n", i, x[i]);

	return 0;
}

