// HPCSE I: find_max() with OpenMP parallel for and reduction
#include <stdio.h>
#include <stdlib.h>
#include <omp.h>

#define VERBOSE 1

double find_max(double *A, int N)
{
#if VERBOSE
	#pragma omp parallel 
	#pragma omp master
	printf("Running with %d threads\n", omp_get_num_threads());
#endif

	double mx = A[0];

	#pragma omp parallel for reduction(max:mx)
	for (int i=0; i<N; i++) {
		if (A[i] > mx) mx = A[i];
	}

	return mx;
}


int main(int argc, char *argv[])
{
	int N = 32*1024*1024;

	double *a = (double *)malloc(N*sizeof(double));

	srand48(1);
	for (int i = 0; i < N; i++) a[i] = drand48();

	double t0 = omp_get_wtime();
	double mx = find_max(a, N);
	double t1 = omp_get_wtime();

	printf("max value = %.16f, elapsed time = %lf seconds\n", mx, t1-t0);

	free(a);

	return 0;
}
