// find_max() with OpenMP parallel for + threadprivate.
// For the sake of completeness. Hopefully we will not need the threadprivate clause in our codes.
// The threadprivate clause is transformed by the compiler
// to code quite similar to that shown in findmax_omp_parallelfor.c
#include <stdio.h>
#include <stdlib.h>
#include <omp.h>

#define VERBOSE 1

double find_max(double *A, int N)
{
#if VERBOSE
	#pragma omp parallel
	#pragma omp master
	printf("Running with %d threads\n", omp_get_num_threads());
#endif

	double mx; 

	static double thread_mx;
	#pragma omp threadprivate(thread_mx)

	#pragma omp parallel
	{
	thread_mx = A[0];
	}

	#pragma omp parallel for 
	for (int i=0; i<N; i++) {
		if (A[i] > thread_mx) thread_mx = A[i];
	}


	#pragma omp parallel
	{
		#pragma omp critical
		if (thread_mx > mx) mx = thread_mx;
	}

	return mx;
}


int main(int argc, char *argv[])
{
	int N = 32*1024*1024;

	double *a = (double *)malloc(N*sizeof(double));

	srand48(1);
	for (int i = 0; i < N; i++) a[i] = drand48();

	double t0 = omp_get_wtime();
	double mx = find_max(a, N);
	double t1 = omp_get_wtime();

	printf("max value = %.16f, elapsed time = %lf seconds\n", mx, t1-t0);

	free(a);

	return 0;
}
