// pi computation using parallel region and worksharing
// Note: this code uses a local variable to avoid false sharing
#include <stdio.h>
#include <omp.h>

long num_steps = 10000000000;
double step;

#define NUM_THREADS 2

int main()
{
	double x, pi, sum[NUM_THREADS];
	step = 1.0/(double) num_steps;

	omp_set_num_threads(NUM_THREADS);

	double t0 = omp_get_wtime();
	#pragma omp parallel private(x)
	{
		int id = omp_get_thread_num();
		double lsum = 0.0;

		#pragma omp for
		for (long i=0; i<num_steps; i++)
		{
			x = (i+0.5)*step;
			lsum = lsum + 4.0/(1.0+x*x);
		}
		sum[id] = lsum;
	}

	pi=0.0;
	for (int i=0; i<NUM_THREADS; i++) pi += sum[i]*step;

	double t1 = omp_get_wtime();

	printf("Pi is %lf, elapsed time = %f s\n", pi, t1-t0);

	return 0;
}
