// loop parallelization with worksharing
#include <stdio.h>
#include <stdlib.h>
#include <omp.h>
#include <math.h>

#define N (256*1024*1024)

double a[N], b[N];

int main()
{

	srand48(1);

	for (int i = 0; i < N; i++) a[i] = drand48();
	for (int i = 0; i < N; i++) b[i] = drand48();


	double t0 = omp_get_wtime();
	#pragma omp parallel for
	for (int i = 0; i < N; i++) a[i] = sin(a[i])*cos(b[i]);
	double t1 = omp_get_wtime();

	printf("Elapsed time = %f s\n", t1-t0);

	return 0;
}

