// loop parallelization using parallel regions
// Note: VALIDATE enables validation of the results
#include <stdio.h>
#include <stdlib.h>
#include <omp.h>
#include <math.h>

#define N (256*1024*1024)

double a[N], b[N];

//#define VALIDATE

#if defined(VALIDATE)
double check[N];
#endif

int main()
{

	srand48(1);

	for (int i = 0; i < N; i++) a[i] = drand48();
	for (int i = 0; i < N; i++) b[i] = drand48();

#if defined(VALIDATE)
	for (int i = 0; i < N; i++) check[i] = sin(a[i])*cos(b[i]);
#endif


	double t0 = omp_get_wtime();
	#pragma omp parallel
	{
	int id = omp_get_thread_num();
	int nthr = omp_get_num_threads();

	int istart = id * (N/nthr);
	int iend = (id+1) * (N/nthr);
	if (id == nthr-1) iend = N;	// possible unfair work adjustment for the last thread ;-)

	for (int i = istart; i < iend; i++) a[i] = sin(a[i])*cos(b[i]);

	}
	double t1 = omp_get_wtime();

#if defined(VALIDATE)
	for (int i = 0; i < N; i++)
		if (a[i] != check[i])
		{
			printf("check failed at %d, %f vs %f\n", i, a[i], check[i]);
			exit(1);
		}
#endif

	printf("Elapsed time = %f s\n", t1-t0);

	return 0;
}

