// sections
#include <stdio.h>
#include <unistd.h>
#include <omp.h>

void x_calculation()
{
	sleep(1);
	printf("x_calculation on thread %d\n", omp_get_thread_num());
}

void y_calculation()
{
	sleep(1);
	printf("y_calculation on thread %d\n", omp_get_thread_num());
}

void z_calculation()
{
	sleep(1);
	printf("z_calculation on thread %d\n", omp_get_thread_num());
}

int main()
{
        int nthreads;
#pragma omp parallel
#pragma omp master
        nthreads = omp_get_num_threads();

        printf("Number of threads = %d\n", nthreads);

#pragma omp parallel
#pragma omp sections
{
	#pragma omp section
	x_calculation();

	#pragma omp section
	y_calculation();

	#pragma omp section
	z_calculation();
}

        return 0;
}



