// private, firstprivate and shared
#include <stdio.h>
#include <omp.h>

int main()
{
	int A = 1;
	int B = 2;
	int C = 3; 

#pragma omp parallel private(A) firstprivate(B) shared(C)
{
	int me = omp_get_thread_num();
	int nthr = omp_get_num_threads();

	printf("Hello world from thread %d of %d: A=%d, B=%d, C=%d\n", me, nthr, A, B, C);	// expect a warning if -Wall is active
}

	printf("Master thread: A=%d, B=%d, C=%d\n", A, B, C);

	return 0;
}
