// manual reduction on an dynamic array
#include <stdio.h>
#include <omp.h>
#include <stdlib.h>

int main()
{
	int *counter;

	int n = 6;
	counter = (int *) calloc(1, n*sizeof(int));

#pragma omp parallel
{
	int me = omp_get_thread_num();
	int nthr = omp_get_num_threads();

	printf("Hello world from thread %d of %d\n", me, nthr);

	int *local_counter;
	local_counter = (int *) calloc(1, n*sizeof(int));

	for (int i = 0; i < n; i++)
	{
		local_counter[i] += 100*i + me;
	}

	#pragma omp critical
	{
		for (int i = 0; i < n; i++)
			counter[i] += local_counter[i];	
	}

}

	for (int i = 0; i < n; i++)
		printf("counter[%d] = %d\n", i, counter[i]);


	return 0;

}
