// reduction on an dynamic array (works only for OpenMP v4.5)
#include <stdio.h>
#include <omp.h>
#include <stdlib.h>

int main()
{
	int *counter;

	int n = 6;
	counter = (int *) calloc(1, n*sizeof(int));

#pragma omp parallel reduction(+:counter[:n])
{
	int me = omp_get_thread_num();
	int nthr = omp_get_num_threads();

	printf("Hello world from thread %d of %d\n", me, nthr);

	for (int i = 0; i < n; i++)
	{
		counter[i] += 100*i + me;
	}

}

	for (int i = 0; i < n; i++)
		printf("counter[%d] = %d\n", i, counter[i]);


	return 0;

}
