// reduction on an array (works only for OpenMP v4.5)
#include <stdio.h>
#include <omp.h>

int main()
{
	int counter[2];

	counter[0] = 0;
	counter[1] = 0; 

#pragma omp parallel reduction(+:counter)
{
	int me = omp_get_thread_num();
	int nthr = omp_get_num_threads();

	printf("Hello world from thread %d of %d\n", me, nthr);

	counter[0] += me;
	counter[1] += 100*me;
}

	printf("counter[0] = %d\n", counter[0]);
	printf("counter[1] = %d\n", counter[1]);


	return 0;

}
