// race condition
// Task: predict the printed value of the counter variable :-)
#include <stdio.h>
#include <omp.h>

int main()
{
	int nthreads;
#pragma omp parallel
#pragma omp master
	nthreads = omp_get_num_threads();

	int niters = 1000000;

	unsigned long counter = 0;

	#pragma omp parallel
	{
		for (int i = 0; i < niters; i++)
			counter++;
	}

        printf("Number of threads = %d, Expected value = %ld, Counter = %ld\n", nthreads, (long)nthreads*niters, counter);

	return 0;
}
