// Openmp locks
#include <stdio.h>
#include <omp.h>

int main()
{
	int counter = 0; 
	omp_lock_t lck;

	omp_init_lock(&lck);

#pragma omp parallel
{
	int me = omp_get_thread_num();
	int nthr = omp_get_num_threads();

	printf("Hello world from thread %d of %d\n", me, nthr);

	omp_set_lock(&lck);
	counter += me;
	omp_unset_lock(&lck);
}
	omp_destroy_lock(&lck);

	printf("counter = %d\n", counter);


	return 0;

}
