// loop + schedule clause
// Task: try different loop scheduling policies

#include <stdio.h>
#include <omp.h>
#include <unistd.h>

void work(int i)
{
	printf("Iteration %d on thread %d\n", i, omp_get_thread_num());
	sleep(1);	// useful for dynamic scheduling policies
}

int main()
{
	int nthreads;
#pragma omp parallel
#pragma omp master
	nthreads = omp_get_num_threads();

        printf("Number of threads = %d\n", nthreads);

//	#pragma omp parallel for schedule(static)
//	#pragma omp parallel for schedule(static,1)
//	#pragma omp parallel for schedule(dynamic,1)
	#pragma omp parallel for schedule(guided)
	for (int i = 0; i < 20; i++)
		work(i);

	return 0;
}
