// conditinal compilation of OpenMP
#include <stdio.h>

#if defined(_OPENMP)
#include <omp.h>
#else

#define omp_get_thread_num()  (0)
#define omp_get_num_threads() (1)
#endif

int main()
{

#pragma omp parallel
{
	int me = omp_get_thread_num();
	int nthr = omp_get_num_threads();

	printf("Hello world from thread %d of %d\n", me, nthr);
}

	return 0;
}
