// reduction using omp atomic
#include <stdio.h>
#include <omp.h>

int main()
{
	int counter = 0; 

#pragma omp parallel
{
	int me = omp_get_thread_num();
	int nthr = omp_get_num_threads();

	printf("Hello world from thread %d of %d\n", me, nthr);

	#pragma omp atomic
	counter += me;

	//!!Avoid the following (major) mistake
	//#pragma omp atomic
	//{
	//counter += me;
	//me++;
	//}
}

	printf("counter = %d\n", counter);

	return 0;

}
