#include <stdio.h>
#include <stdlib.h>
#if defined(__APPLE__) && defined(USE_ACCELERATE)
#include <Accelerate/Accelerate.h>
#else
#include <cblas.h>
#endif

// print row-major matrix
void print_matrix(double * mp, size_t n) {
    for(size_t i = 0; i < n; ++i) {
        for(size_t j = 0; j < n; ++j)
            printf(" %lf", mp[i*n+j]);
        printf("\n");
    }
}

int main() {

    const int n = 2;
    const int N = n*n;

    double *A = malloc(N*sizeof(double));
    double *B = malloc(N*sizeof(double));
    double *C = malloc(N*sizeof(double));

    for(size_t i = 0; i < N; ++i) {
        A[i] = i+1;
        B[i] = i;
    }

    printf("A=\n");
    print_matrix(A, n);
    printf("B=\n");
    print_matrix(B, n);

   /*
    void cblas_dgemm(const enum CBLAS_ORDER __Order,
        const enum CBLAS_TRANSPOSE __TransA,
        const enum CBLAS_TRANSPOSE __TransB, const int __M, const int __N,
        const int __K, const double __alpha, const double *__A,
        const int __lda, const double *__B, const int __ldb,
        const double __beta, double *__C, const int __ldc)
    */


    cblas_dgemm(CblasRowMajor, CblasNoTrans, CblasNoTrans, n, n, n, 1.0, A, n, B, n, 1.0, C, n);

    printf("C=\n");
    print_matrix(C, n);

    free(A);
    free(B);
    free(C);

    return 0;
}

