#include <stdio.h>
#include <stdlib.h>
//#if defined(__APPLE__) && defined(USE_ACCELERATE)
//#include <Accelerate/Accelerate.h>
//#else
#include <lapack.h>
//#endif

// print row-major matrix
void print_matrix(double * mp, size_t n) {
    for (size_t i = 0; i < n; ++i) {
        for (size_t j = 0; j < n; ++j)
            printf(" %lf", mp[i*n+j]);
        printf("\n");
    }
}

void transpose(double *mp, size_t n) {
    double *tmp = malloc(n*n*sizeof(double));
    for (size_t i = 0; i < n; ++i)
        for (size_t j = 0; j < n; ++j)
            tmp[i*n+j] = mp[i+j*n];

    for (size_t i = 0; i < n; ++i)
        for (size_t j = 0; j < n; ++j)
            mp[i*n+j] = tmp[i*n+j];

    free(tmp);
}


int main() {

    const int n = 2;

    double *A = malloc(n*n*sizeof(double));
    double *B = malloc(n*n*sizeof(double));
    double *C = malloc(n*n*sizeof(double));

    for(size_t i = 0; i < n*n; ++i) {
        A[i] = i+1;
        B[i] = i;
    }

    printf("A=\n");
    print_matrix(A, n);
    printf("B=\n");
    print_matrix(B, n);

   /*
   void BLASFUNC(dgemm)(char *, char *, blasint *, blasint *, blasint *, double *,
     double *, blasint *, double *, blasint *, double *, double *, blasint *);

   subroutine dgemm(character		TRANSA,
										character		TRANSB,
										integer			M,
										integer			N,
										integer			K,
										double precision 	ALPHA,
										double precision, dimension(lda,*) 	A,
										integer 	LDA,
										double precision, dimension(ldb,*) 	B,
										integer 	LDB,
										double precision 	BETA,
										double precision, dimension(ldc,*) 	C,
										integer 	LDC
		)
    */


    //transpose(A, n);
    //transpose(B, n);

    char TRANSA = 'T';
    char TRANSB = 'T';
    int M = n;
    int N = n;
    int K = n;
    double ALPHA = 1.0;
    int LDA = n;
    int LDB = n;
    double BETA = 0.0;
    int LDC = n;

    dgemm_(&TRANSA, &TRANSB, &M, &N, &K, &ALPHA, A, &LDA, B, &LDB, &BETA, C, &LDC);

    transpose(C, n);
    printf("C=\n");
    print_matrix(C, n);

    free(A);
    free(B);
    free(C);

    return 0;
}

