#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <math.h>
#include <omp.h>

double get_wtime(void)
{
  struct timeval t;
  gettimeofday(&t, (struct timezone *)NULL);
  return (double)t.tv_sec + t.tv_usec*0.000001;
}

#ifndef SIZE
#define	SIZE	(128*1024*1024)
#endif

void copy(double *a, double *b, unsigned long n)
{
	for (unsigned long i=0; i<n; i++)
		b[i] = a[i];
}

int main(int argc, char *argv[])
{
	double *a = calloc(1, SIZE*sizeof(double));
	double *b = malloc(SIZE*sizeof(double));

	for (unsigned long i=0; i<SIZE; i++) {
		a[i] = 1.0;
		b[i] = 2.0;
	}

	double t0, t1;

	t0 = get_wtime();
	copy(a, b, SIZE);
	t1 = get_wtime();

	double s = 0;
	for (unsigned long i=0; i < SIZE; i++) s += b[i];
	printf("s=%lf\n", s);

	printf("copy %ld bytes in %e s [%.3lf] MB/s\n", SIZE*sizeof(double), t1-t0, (1/1024.0)*(1/1024.0)*2*SIZE*sizeof(double)/(t1-t0));

	return 0;
}
