#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

double get_wtime(void)
{
  struct timeval t;

  gettimeofday(&t, NULL);

  return (double)t.tv_sec + (double)t.tv_usec*1.0e-6;
}


#define N (128*1024*1024)

struct {
	double x[N];
	double y[N];
//	double z[N];
} points;

int main()
{
	double result = 0;

	srand48(10);
	for (int i = 0; i < N ; ++ i) {
		points.x[i] = drand48();
		points.y[i] = drand48();
	}

	for (int i = 0; i < N ; ++i) {
		result += (points.x[i]);
	}

	result = 0;
	double t0 = get_wtime();
	for (int i = 0; i < N ; ++i) {
		result += (points.x[i]);
	}
	double t1 = get_wtime();

	printf("result = %f, elapsed time %lf\n", result/N, t1-t0);
	return 0;
}
