#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <sys/time.h>

double get_wtime(void)
{
  struct timeval t;

  gettimeofday(&t, NULL);

  return (double)t.tv_sec + (double)t.tv_usec*1.0e-6;
}

typedef struct Quadratic_s {
	float a, b, c;
	//float pad[5];
} Quadratic;


const int count = 1 << 26;


int main(int argc, char *argv[])
{
	Quadratic *e = (Quadratic *)malloc(count*sizeof(Quadratic));
	float *roots = (float *)malloc(count*sizeof(double));

	for (int i=0; i < count; i++) {
		e[i].a = 1 + (rand() % 10);
		e[i].b = 1 + (rand() % 10) + 20;
		e[i].c = 1 + (rand() % 10);
	}


  double t0, t1;
  t0 = get_wtime();
	for (int i=0; i < count; i++) {
		roots[i] = (-e[i].b + sqrt(e[i].b*e[i].b - 4.0*(e[i].a*e[i].c))) / (2.0*e[i].a);
	}
  t1 = get_wtime();
  printf("%d roots in %.3f s\n",  count, t1-t0);

	double s = 0.0;
	for (int i=0; i < count; i++) s += roots[i];

	printf("sum of roots = %lf\n", s);

	return 0;
}






