#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

double get_wtime(void)
{
  struct timeval t;

  gettimeofday(&t, NULL);

  return (double)t.tv_sec + (double)t.tv_usec*1.0e-6;
}

#define N (1024*16)
double d[N][N];

int main(int argc, char *argv[])
{
	srand48(1);
	for (int i = 0; i < N; i++)
		for (int j = 0; j < N; j++)
			d[i][j] = -1.0 + 2.0*drand48();


	double t0, t1;
	double s1 = 0;

	t0 = get_wtime();
	for (int i = 0; i < N; i++)
		for (int j = 0; j < N; j++)
			s1 += d[i][j];
	t1 = get_wtime();

  printf("s1=%.6lf\n", s1);
  printf("t1-t0=%.6lf seconds\n", t1-t0);

	double s2 = 0;
	t0 = get_wtime();
	for (int j = 0; j < N; j++)
		for (int i = 0; i < N; i++)
			s2 += d[i][j];
	t1 = get_wtime();

  printf("s2=%.6lf\n", s2);
  printf("t1-t0=%.6lf seconds\n", t1-t0);

	return 0;
}
