#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

double get_wtime(void)
{
  struct timeval t;

  gettimeofday(&t, NULL);

  return (double)t.tv_sec + (double)t.tv_usec*1.0e-6;
}


#define N (128*1024*1024)

typedef struct {
	double x;
	double y;
	double z;
	double w;
} point_t ;

point_t points[N];

int main()
{
	double result = 0;

	srand48(10);
	for (int i = 0; i < N ; ++ i) {
		points[i].x = drand48();
		points[i].y = drand48();
	}

	for (int i = 0; i < N; ++i) {
		result += (points[i].x);
	}

	result = 0;
	double t0 = get_wtime();
	for (int i = 0; i < N; ++i) {
		result += (points[i].x);
	}
	double t1 = get_wtime();

	printf("result = %f, elapsed time %lf\n", result/N, t1-t0);

	return 0;
}
