#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <math.h>

double get_wtime(void)
{
	struct timeval t;
	gettimeofday(&t, (struct timezone *)NULL);
	return (double)t.tv_sec + t.tv_usec*0.000001;
}

void matmul(double *a, double *b, double *c, int n)
{
#define a(i,j)	a[i*n+j]
#define b(i,j)	b[i*n+j]
#define c(i,j)	c[i*n+j]

	for (int i=0; i < n; i++) {
		for (int j=0; j < n; j++) {
				//c(i,j) = 0.0;
				for (int k=0; k < n; k++) {
					c(i,j) += a(i,k) * b(k,j);
				}
		}
	}
}

int main(int argc, char **argv)
{
	double *a, *b, *c;
	double t_start, t_end;

	int n = 1000;
	if (argc >= 2) {
		n = atoi(argv[1]);
	}

	a = (double* ) malloc(n * n * sizeof(double));
	b = (double* ) malloc(n * n * sizeof(double));

	/*Create random matrix */
	srand(5);
	for (int i=0; i < n; i++) {
		for (int j=0; j < n; j++) {
			a[i*n+j] = (double)(rand()/(double)RAND_MAX);
			b[i*n+j] = (double)(rand()/(double)RAND_MAX);
		}
	}

	c = (double* ) calloc(1, n * n * sizeof(double));


	/* Triple loop */
	t_start = get_wtime();
	matmul(a, b, c, n);
	t_end = get_wtime();
	printf("Time with triple loop %.3lf s \n", t_end - t_start);

	return 0;
}

